//
//  MCChartsmithInterface.h
//  MCApplication
//
//  Created by Alykhan Jetha on Tue Apr 15 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//


#import "MCRemoteAppleScriptApplication.h"

@interface MCChartsmithInterface : MCRemoteAppleScriptApplication {

}

- (void)createDocumentIfNecessary;
- (void)createChartOfType:(NSString*)type atIndex:(int)chartIndex;
- (void)addRowAtIndex:(int)rowIndex toChartAtIndex:(int)chartIndex;
- (void)addRows:(int)count atIndex:(int)rowIndex toChartAtIndex:(int)chartIndex;
- (void)setRowLabel:(NSString*)label atRowIndex:(int)rowIndex ofChartAtIndex:(int)chartIndex;
- (void)setRowLabels:(NSString*)labelsString ofChartAtIndex:(int)chartIndex;
- (void)setDataValue:(float)value forRow:(int)row column:(int)column subcolumn:(int)subcolumn ofChartAtIndex:(int)chartIndex;
- (void)setDataValues:(NSString*)dataString ofChartAtIndex:(int)chartIndex;
- (void)applyTemplateAtPath:(NSString*)path toChartAtIndex:(int)chartIndex;
- (void)setTitle:(NSString*)aTitle toChartAtIndex:(int)chartIndex;
- (void)setSubTitle:(NSString*)aTitle toChartAtIndex:(int)chartIndex;
- (void)exportChartAtIndex:(int)chartIndex toPath:(NSString*)path;

- (void)setSeriesLabel:(NSString *)label atSeriesIndex:(int)seriesIndex ofChartAtIndex:(int)chartIndex;


@end
